//#include "Newton.h"
#include "NewtonScript.h"
//#include "Unicode.h"
//#include "UStringUtils.h"

extern "C" Ref CheckCode(RefArg receiver, RefArg theString, RefArg theCode);

extern "C" Ref CheckCode(RefArg receiver, RefArg theString, RefArg theCode)
{
	if (!IsString(theString))
		return NILREF;
	
	TrimString(theString);
	
	long code = RefToInt(theCode);
	
	long result = 12345;
	
	WITH_LOCKED_BINARY(theString, thePtr)
	char *ptr = (char*)thePtr;
	
	for (int i = 0; i < Length(theString); ++i)
	{
		if (ptr[i] != 0)
			result *= ptr[i];
		result = (result << 1) ^ (result >> 1);
	}
	END_WITH_LOCKED_BINARY(theString)
	
	result &= 0x1FFFFFFF;

	if (result == code)
		return TRUEREF;
	else
		return NILREF;
}

