
constant kMethodPost		:= "POST";
constant kMethodGet			:= "GET";
constant kNewline			:= unicodeCR & unicodeLF;
constant kCRLF := kNewLine;

constant kHTTPVer			:= "HTTP/1.0";
constant kUserAgent			:= "User-Agent: XML-RPC for Newton/1.0";
constant kHost				:= "Host:";
constant kXMLContentType	:= "Content-Type: text/xml";
constant kFormBoundary		:= "AaB03x";
constant kFormContentType	:= "Content-type: multipart/form-data, boundary=" & kFormBoundary;
constant kContentLength		:= "Content-length:";


constant kTab			:= "\t"; // "";

constant kValueStart	:= "<value>";
constant kValueClose	:= "</value>";

constant kBooleanStart	:= "<boolean>";
constant kBooleanClose	:= "</boolean>";

constant kStringStart	:= "<string>";
constant kStringClose	:= "</string>";

constant kBase64Start	:= "<base64>";
constant kBase64Close	:= "</base64>";

constant kTimeStart		:= "<dateTime.iso8601>";
constant kTimeClose		:= "</dateTime.iso8601>";

constant kIntStart		:= "<int>";
constant kIntClose		:= "</int>";

constant kDoubleStart	:= "<double>";
constant kDoubleClose	:= "</double>";

constant kStructStart	:= "<struct>";
constant kStructClose	:= "</struct>";

constant kMemberStart	:= "<member>";
constant kMemberClose	:= "</member>";

constant kNameStart		:= "<name>";
constant kNameClose		:= "</name>";

constant kArrayStart	:= "<array>";
constant kArrayClose	:= "</array>";

constant kDataStart		:= "<data>";
constant kDataClose		:= "</data>";

constant kParamsStart	:= "<params>";
constant kParamsClose	:= "</params>";

constant kParamStart	:= "<param>";
constant kParamClose	:= "</param>";

constant kMethodCallStart	:= "<methodCall>";
constant kMethodCallClose	:= "</methodCall>";

constant kMethodResponseStart	:= "<methodResponse>";
constant kMethodResponseClose	:= "</methodResponse>";

constant kMethodNameStart	:= "<methodName>";
constant kMethodNameClose	:= "</methodName>";

constant kFaultStart	:= "<fault>";
constant kFaultClose	:= "</fault>";

constant kFaultCode		:= "faultCode";
constant kFaultString	:= "faultString";

constant kPayloadStart	:= "<payload>";
constant kPayloadClose	:= "</payload>";

constant kXMLHeader		:= "<?xml version=\"1.0\"?>";




DefConst('kAddTabsFunc, func(level, message, tag) begin
	local i;
	
	message := message & kNewline;
	
	for i := 0 to level - 1 by 1 do begin
		message := message & kTab;
	end;
	
	message := message & tag;
	
	return message;
end);
