//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include "Newton.H"

char Package_C_rcsid[] = "$Id: Package.C,v 1.7 1997/09/20 16:26:58 spoonman Exp $";


//
// The following functions (excluding the final C++ methods)
// were adapted from Philz's (http://www.wnet.silesia.pl/~philz/)
// Linux package loader.  My integration of the code ain't perfect,
// but damn if it doesn't work.  Clean up/better integration is
// on its way...  -A
//

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <netinet/in.h>

#define SYN 0x16
#define DLE 0x10
#define STX 0x02
#define ETX 0x03

#define LR  1
#define LD  2
#define LT  4
#define LA  5
#define LN  6
#define LNA 7

//
// CRC stuff
//

static unsigned long crcinit = 0;

static unsigned short crctab[256] =
  {
  0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241,
  0xc601, 0x06c0, 0x0780, 0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440,
  0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1, 0xce81, 0x0e40,
  0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841,
  0xd801, 0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40,
  0x1e00, 0xdec1, 0xdf81, 0x1f40, 0xdd01, 0x1dc0, 0x1c80, 0xdc41,
  0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680, 0xd641,
  0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040,
  0xf001, 0x30c0, 0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240,
  0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501, 0x35c0, 0x3480, 0xf441,
  0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
  0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840,
  0x2800, 0xe8c1, 0xe981, 0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41,
  0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1, 0xec81, 0x2c40,
  0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640,
  0x2200, 0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041,
  0xa001, 0x60c0, 0x6180, 0xa141, 0x6300, 0xa3c1, 0xa281, 0x6240,
  0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480, 0xa441,
  0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41,
  0xaa01, 0x6ac0, 0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840,
  0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01, 0x7bc0, 0x7a80, 0xba41,
  0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
  0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640,
  0x7200, 0xb2c1, 0xb381, 0x7340, 0xb101, 0x71c0, 0x7080, 0xb041,
  0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0, 0x5280, 0x9241,
  0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440,
  0x9c01, 0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40,
  0x5a00, 0x9ac1, 0x9b81, 0x5b40, 0x9901, 0x59c0, 0x5880, 0x9841,
  0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81, 0x4a40,
  0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41,
  0x4400, 0x84c1, 0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641,
  0x8201, 0x42c0, 0x4380, 0x8341, 0x4100, 0x81c1, 0x8081, 0x4040,
  };

static unsigned long updcrc(unsigned short icrc,
  unsigned char *icp, int icnt)
  {
  register unsigned short crc = icrc;
  register unsigned char *cp = icp;
  register int cnt = icnt;

  while(cnt--)
    {
    crc=((crc>>8)& 0xff)^crctab[(crc&0xff)^*cp++];
    }
  return(crc);
  };


//
// FRAME STUFF
//


static inline void fcscalc(unsigned short *fcs, unsigned char data)
  {
  *fcs = updcrc(*fcs, &data, 1);
  };

int Newton::ReadFrame(char *buff)
  {
  char buf=SYN;
  int count=0;
  char *org=buff;
  unsigned short fcs=0;
  unsigned short fcs_rec=0;

  for (; buf==SYN; buf=getc(NewtonFDS));
  if (buf == DLE && getc(NewtonFDS) == STX)
    {
    for(;;)
      {
      buf = getc(NewtonFDS);
      if (buf == DLE)
        {
        buf = getc(NewtonFDS);
        if (buf == ETX)
          {
          fcscalc(&fcs,buf);
          fcs_rec = getc(NewtonFDS);
          fcs_rec |= getc(NewtonFDS) << 8;
          if (fcs_rec == fcs)
            {
            return(count);
            }
          else
            {
            fprintf(stderr,"Bad CRC\n");
            fflush(stderr);
            return -1;
            };
          }
        else
          {
          if (buf==DLE)
            {
            *buff++ = buf;
            fcscalc(&fcs,buf);
            count++;
            }
          else
            {
            fprintf(stderr,"Invalid frame\n");
            fflush(stderr);
            return -1;
            };
          };
        }
      else
        {
        *buff++ = buf;
        fcscalc(&fcs,buf);
        count++;
        };
      };
    };
  };

int Newton::SendFrame(char *buff, int size)
  {
  int i;
  unsigned short fcs = 0;

  putc(SYN,NewtonFDS);
  putc(DLE,NewtonFDS);
  putc(STX,NewtonFDS);

  for(i=0;i<size;i++)
    {
    putc(buff[i],NewtonFDS);
    if(buff[i]==DLE)
      putc(DLE,NewtonFDS);
    fcscalc(&fcs, buff[i]);
    };

  putc(DLE,NewtonFDS);
  putc(ETX,NewtonFDS);
  fcscalc(&fcs, ETX);
  putc(fcs&0x00ff,NewtonFDS);
  putc((fcs&0xff00)>>8,NewtonFDS);
  fflush(NewtonFDS);
  };

int Newton::SendLA(unsigned char nr,unsigned char cr)
  {
  char la[] = {3,5,0,0};
  la[2]=nr;
  la[3]=cr;
  SendFrame(la, sizeof(la));
  };

int Newton::SendData(char *data, int size)
  {
  char buf[2048];
  char buf2[8];
  int index;

  buf[0] = 2;
  buf[1] = 4;
  buf[2] = scount;

  for(index=0;index<size;index++)
    buf[index+3]=data[index];

  for(;;)
    {
    SendFrame(buf,size+3);
    ReadFrame(buf2);
    if(buf2[0] == 3 && buf2[1] == 5 && buf2[2] == scount)
      {
      scount++;
      return size;
      };
    };
  };

int Newton::ReceiveData(char *data, int size)
  {
  char buf[2048];
  int framesize, index;

  for(;;)
    {
    framesize = ReadFrame(buf);
    if(framesize > 0)
      {
      SendLA(rcount++, 1);
      framesize = framesize > size ? size : framesize;
      for(index=0; index < framesize; index++)
        {
        data[index] = buf[index+3];
        };
      return framesize;
      };
    };
  };

int Newton::WaitConnection()
  {
  char lr[]={23,1,2,1,6,1,0,0,0,0,255,2,1,2,3,1,1,4,2,64,0,8,1,3};
  char buf[64];

  while(ReadFrame(buf)<0);
  SendFrame(lr, sizeof(lr));
  rcount=1;
  ReadFrame(buf);
  scount=1;
  };

int Newton::SendDisconnect()
  {
  char ld[]={7,2,1,1,255,2,1,0};
  SendFrame(ld, sizeof(ld));
  };



#ifdef NewtonYAPI

// Write from a File to the NewtonDevice
int Newton::LoadPackageXMODEM(const String FileName)
  {
  return(LoadPackageXMODEM(FileName.chars()));
  };

// Write from a File to the NewtonDevice
int Newton::LoadPackageXMODEM(const char *FileName)
  {
  String syscall;
  int retcode;

  syscall = "cat " + NewtonDeviceName + " | " + unixSX + " " + FileName + \
            " > " + NewtonDeviceName;
  retcode = system(syscall.chars());  

  return(retcode);
  };

#endif


// Write from a File to the NewtonDevice
int Newton::LoadPackage(const String FileName)
  {
  return(LoadPackage(FileName.chars()));
  };

// Write from a File to the NewtonDevice
int Newton::LoadPackage(const char *FileName)
  {
  String syscall;
  int i, j, fd, nw, bytes;
  unsigned int size;
  struct stat st;
  char *package;
  char newtdockdock[] =
         {'n','e','w','t','d','o','c','k','d','o','c','k',0,0,0,4,0,0,0,4};
  char newtdockstim[] =
         {'n','e','w','t','d','o','c','k','s','t','i','m',0,0,0,4,0,0,0,5};
  char newtdocklpkg[] =
         {'n','e','w','t','d','o','c','k','l','p','k','g',0,0,0x2f,0xa0};
  char newtdockdisc[] =
         {'n','e','w','t','d','o','c','k','d','i','s','c',0,0,0,0};
  char buf[128];

  fd = open(FileName,O_RDONLY);
  fstat(fd, &st);
  (unsigned long)*(newtdocklpkg+12) = htonl(st.st_size);

  fprintf(stderr,"Hit \"Connect\" on Newton...");
  WaitConnection();
  fprintf(stderr, "\rConnecting...             ");
  ReceiveData(buf,sizeof(buf));                  // newtdockrtdk
  SendData(newtdockdock,sizeof(newtdockdock));   // newtdockdock
  ReceiveData(buf,sizeof(buf));                  // newtdockname
  SendData(newtdockstim,sizeof(newtdockstim));   // newtdockstim
  ReceiveData(buf,sizeof(buf));                  // newtdockdres
  fprintf(stderr, "\rLoading %s, %d bytes\n", FileName,st.st_size);
  SendData(newtdocklpkg,sizeof(newtdocklpkg));   // newtdocklpkg

  bytes = read(fd,buf,sizeof(buf));
  fprintf(stderr, "\r%8d / %8d", size = bytes, st.st_size);
  SendData(buf, bytes);
  while(bytes == sizeof(buf))
    {
    bytes = read(fd, buf, sizeof(buf));
    fprintf(stderr, "\r%8d / %8d", size += bytes, st.st_size);
    SendData(buf, bytes);
    };
  ReceiveData(buf, sizeof(buf));                 // newtdockdres
  SendData(newtdockdisc, sizeof(newtdocklpkg));  // newtdockdisc
  SendDisconnect();
  fprintf(stderr,"\n");
  fflush(stderr);
  return(NewtonOK);
  };

