#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4Kjots
#---------------------------------------------------------------------

# $Log: Get4Kjots.pl,v $
# Revision 1.8  1998/09/02 13:54:13  kalli
# *** empty log message ***
#
# Revision 1.7  1998/09/01 14:52:17  kalli
# Umstellung auf Notes-File : Newtonlink Notesfile wird gelesen und als Kjots-File
# geschrieben.
#
# Revision 1.6  1998/06/28 16:33:00  kalli
# Aenderungen vo Tosten Uhlmann :
# select dazu, neue Replaces
#
# Revision 1.5  1998/03/16 14:57:33  kalli
# Umstellung auf ser. Treiber mit Timeout
#
# Revision 1.4  1998/03/07 17:29:44  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.3  1998/02/07 19:54:48  kalli
# Aenderung von Torsten :
# Sortierund der Notes
#
# Revision 1.1  1998/02/01 18:07:51  kalli
# Initial revision
#

sub Get4Kjots {
    
    # Get actual Newton notes
    &GetNotes;

    # save old Kjots file
    if (-e "$KjotsFile") {
	rename ("$KjotsFile", "$KjotsFile.bak");
    }

    # Open Newtonlink notes file
    open (NLNOTESFILE, "$NLNotesFile")  || die "Can't open File : $NLNotesFile\n";

    # Open new Kjots file
    open (KJFILE, ">> $KjotsFile")  || die "Can't open File : $KjotsFile\n";

    # print to stdout
    printf "Writing kjots file $KjotsFile ...\n";

    while (<NLNOTESFILE>) {
        print KJFILE $_
    }
   
    close (KJFILE);
    close (NLNOTESFILE);    
}

1;



