#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetFaxOutbox
#---------------------------------------------------------------------

# $Log: GetFaxOutbox.pl,v $
# Revision 1.8  1998/03/22 19:57:33  kalli
# Preview, Send nach Configfile
#
# Revision 1.7  1998/03/16 20:06:39  kalli
# Erste lauffaehige Version
#
# Revision 1.6  1998/03/07 17:57:47  kalli
# *** empty log message ***
#
# Revision 1.5  1997/09/28 09:57:35  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.4  1997/03/27 19:38:46  kalli
# Andrew dazu
#
# Revision 1.3  1997/02/23 15:09:27  kalli
# Frank dazu
#
# Revision 1.2  1997/02/22 16:59:12  kalli
# GPL dazu ;-)
#
# Revision 1.1  1996/11/24 19:55:02  kalli
# Initial revision
#

sub GetFaxOutbox {

    # start counter
    $FaxCounter = 0;
    # set marker
    $FaxOn = "off";
    
    # send commands to Sloup
    &send_line (COMNEWTON, "\nOutbox\n");
    &send_line (COMNEWTON, '{state: "string", category: "string", fromTitle: "string", fromName: "string", toFullAddress: "string",' . 
                           'timestamp: "date", phoneNumber: "string", body: {title: "string", data: [{text: "string"}]}}');
    &send_line (COMNEWTON, "\nDUMP!\n");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
        s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	# split into 
	($FXstate, $FXcategory, $FXconcern, $FXfromName, $FXtoName, $FXtimestamp, $FXphoneNumber, $FXbodytitle, $FXdata) = split(/\t/, $_, 10);

	# if new outbox entry
	if (defined ($FXstate) && ($FXstate eq "ready")) {

	    if (defined ($FXcategory) && ($FXcategory eq "faxsend:newton")) {

		# set marker
		$FaxOn = "on";

                # Open file
                open  (FXFILE, "> $FaxFile.$FaxCounter")  || die "Can't open File : $!\n";
		
		# print to file
		#printf FXFILE "Fax by Newtonlink (http://privat.swol.de/ReinholSchoeb/Newton/newtonlink-doc-en.html\n";
		#printf FXFILE "------------------------------------------------------------------------------------\n\n";
                printf FXFILE "\n\n";
		printf FXFILE "Concern : $FXconcern\n";
		printf FXFILE "Title   : $FXbodytitle\n";
		printf FXFILE "Time    : $FXtimestamp\n\n";
		printf FXFILE "From $FXfromName\n\n";
		printf FXFILE "To :\n\n";
		printf FXFILE "$FXtoName";
		printf FXFILE "Fax : $FXphoneNumber\n\n";
                printf FXFILE "--------\n\n\n\n";
		printf FXFILE "$FXdata\n";

                # save fax number
		$FaxNumber[$FaxCounter] = $FXphoneNumber;
				
		# Print sign to stdout
		print "#";
		$FaxCounter++;

	    } else {
		# reset marker
		$FaxOn = "off";
	    }
	
	# if not new outbox entry
	} elsif ($FaxOn eq "on") {
	    print FXFILE "$_\n";
	}
    }
    
    # print to stdout
    print ("\n$FaxCounter fax(es) transfered\n");

    close FXFILE;

    if ($FaxCounter > 0) {    

        for ($nFax = 0; $nFax < $FaxCounter; $nFax++) {
	
	    # make fax file
	    if ($FaxMakeCommand ne "") {
                print "\nMaking fax $FaxFile.$nFax ($FaxNumber[$nFax])\n";
                system "$FaxMakeCommand $FaxFile.$nFax $FaxNumber";
	    }
	    
	    # Start previewer
	    if ($FaxPreviewCommand ne "") {
	        printf "Starting previewer\n";
                system "$FaxPreviewCommand $FaxFile.$nFax";
	    }
	    
	    # send fax
	    if ($FaxSendCommand ne "") {
                print "\nSending fax #$nFax ($FaxNumber[$nFax])\n";
                system "$FaxSendCommand $FaxFile.$nFax $FaxNumber";
            }
        }
    }
}

1;
