#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4Addressbook
#---------------------------------------------------------------------

# $Log: Get4Addressbook.pl,v $
# Revision 1.8  1998/09/02 13:53:49  kalli
# *** empty log message ***
#
# Revision 1.7  1998/03/07 12:37:33  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.6  1997/12/06 17:17:17  kalli
# Umstellung auf Sloup
#
# Revision 1.5  1997/09/28 09:48:51  kalli
# Aenderungen von Andrew :
# select-Statement
#
# Revision 1.4  1997/03/27 19:33:28  kalli
# Andrew dazu
#
# Revision 1.3  1997/02/23 15:02:44  kalli
# Frank dazu
#
# Revision 1.2  1997/02/22 16:51:11  kalli
# GPL dazu
#
# Revision 1.1  1996/11/24 19:38:47  kalli
# Initial revision
#

sub Get4Addressbook {

    # reset counter
    $ABc = 0;
    
    # Get actual Newton cards
    &GetCards;

    # save old Addressbook file
    if (-e "$AddressbookFile") {
	rename ("$AddressbookFile", "$AddressbookFile.bak");
    }

    # Open Newtonlink cards file
    open (NLCARDFILE, "$NLCardsFile")  || die "Can't open File : $!\n";

    # Open new addressbook file
    open (PFILE, ">> $AddressbookFile")  || die "Can't open File : $!\n";

    # print to stdout
    printf "Writing addressbook file $AddressbookFile ...\n";
    
    while (<NLCARDFILE>) {

        ($Cardclass, $CardlastName, $CardfirstName, $Cardhonorific, $Cardaddress, $Cardcountry, $Cardpostal_code,
         $Cardcity, $Cardbday, $CardhomePhone, $CardworkPhone, $CardfaxPhone, $Cardemail, $Cardcompany) = split(/;/, $_, 20);

        if ( ($Cardclass eq "company") || ($Cardclass eq "person") || ($Cardclass eq "owner") ) {
	    # save to memory
	    $ABArr[$ABc++] = "$CardlastName;$CardfirstName;$Cardhonorific;$Cardaddress;$Cardcountry;$Cardpostal_code;$Cardcity;$Cardbday;$CardhomePhone;$CardworkPhone;$CardfaxPhone;$Cardemail;$Cardcompany;";
        }
    }

    # sort entrys alpabetical
    @ABArrSorted = sort @ABArr;

    # write cards file
    for ($ABi = 0; $ABi < $ABc; $ABi++) {
   	printf PFILE "$ABArrSorted[$ABi]\n";
    }

    # close files
    close (PFILE);
    close (NLCARDFILE);
}

1;
