#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4Xrolodex
#---------------------------------------------------------------------

# $Log: Get4Xrolodex.pl,v $
# Revision 1.10  1998/09/02 13:56:21  kalli
# *** empty log message ***
#
# Revision 1.9  1998/08/29 17:20:32  kalli
# Select statement wieder eingefuehrt
#
# Revision 1.8  1998/03/22 19:45:43  kalli
# Previewer lt. Configfile
#
# Revision 1.7  1998/03/07 12:24:46  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.6  1997/12/06 17:27:02  kalli
# Umstellung auf Sloup
#
# Revision 1.5  1997/09/28 09:56:02  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.4  1997/03/27 19:37:48  kalli
# Andrew dazu
#
# Revision 1.3  1997/02/23 15:07:22  kalli
# Frank dazu
#
# Revision 1.2  1997/02/22 16:57:52  kalli
# GPL dazu
#
# Revision 1.1  1996/11/24 19:28:35  kalli
# Initial revision
#

sub Get4Xrolodex {

    # Get actual Newton notes
    &GetNotes;

    $NotesCounter = 0;

    # save old Xrolodex file
    if (-e "$XrolodexFile") {
	rename ("$XrolodexFile", "$XrolodexFile.bak");
    }

    # Open Newtonlink notes file
    open (NLNKNOTESFILE, "$NLNotesFile")  || die "Can't open File : $NLNotesFile\n";

    # Open new Xrolodex file
    open (XRFILE, ">> $XrolodexFile")  || die "Can't open File : $XrolodexFile\n";

    if ($XroloPrintCommand ne "") {
	# save old printout file
	if (-e "$XroloPrintFile") {
	    rename ("$XroloPrintFile", "$XroloPrintFile.bak");
	}
	# Open file
	open  (XRPRFILE, ">> $XroloPrintFile")  || die "Can't open File : $XroloPrintFile\n";
    }

    # print to stdout
    printf "Writing xrolodex file $XrolodexFile ...\n";

    while (<NLNKNOTESFILE>) {

        ($FirstWord) = split(/ /, $_, 20);

        if ($FirstWord eq "\\NewEntry") {
            print XRFILE "####\n";
            print XRPRFILE "\n\n\n";
            $NotesCounter++;
        } else {   
            print XRFILE $_;
            print XRPRFILE $_;
        }
    }

    # close files
    close (XRFILE);
    close (NLNKNOTESFILE);

    if ($NotesCounter > 0) {

        if ($XroloPrintCommand ne "") {

	    close (XRPRFILE);
            printf "\nCreate postscript file $XroloPrintFile.ps\n";
	    # convert print file to postscript
	    system "$XroloPrintCommand $XroloPrintFile > $XroloPrintFile.ps";

            # start previewer
            if ($XroloPrintPreviewCommand ne "") {
	        printf "Starting previewer\n";
	        system "$XroloPrintPreviewCommand $XroloPrintFile.ps &";
	    }
        }
	
	if ($XrolodexCommand ne "") {
            printf "Starting Xrolodex\n";
	    system "$XrolodexCommand $XrolodexFile &";
	}
    }
}

1;
